/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskModalDialog;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWPLCredentials
extends VWTaskModalDialog {
    private static final long serialVersionUID = 1L;
    private List<String> m_items = null;
    private String m_chosenItem = null;
    private JComboBox m_itemsComboBox = null;
    private JTextField m_itemTextField = null;
    private VWTaskTabPanel m_mainPanel = null;
    private JTextField m_username = null;
    private JPasswordField m_password = null;
    private JPasswordField m_confirmPassword = null;
    private boolean m_isCanceled = false;

    public static VWPLCredentials getInstance(String chosenItem, String username, String pw, String dialogTitle) {
        Dimension size = VWStringUtils.stringToDimension("335,165");
        if (size == null) {
            size = new Dimension(300, 150);
        }
        return VWPLCredentials.getInstance(size, chosenItem, username, pw, dialogTitle);
    }

    public static VWPLCredentials getInstance(List<String> items, String dialogTitle) {
        Dimension size = VWStringUtils.stringToDimension("335,165");
        if (size == null) {
            size = new Dimension(300, 150);
        }
        return VWPLCredentials.getInstance(size, items, dialogTitle);
    }

    public static VWPLCredentials getInstance(Dimension size, List<String> items, String dialogTitle) {
        return new VWPLCredentials(VWTaskCore.getInstance().getMainFrame(), new JPanel(), dialogTitle, 12, size, items, null, null, null, dialogTitle);
    }

    public static VWPLCredentials getInstance(Dimension size, String chosenItem, String username, String pw, String dialogTitle) {
        return new VWPLCredentials(VWTaskCore.getInstance().getMainFrame(), new JPanel(), dialogTitle, 12, size, null, chosenItem, username, pw, dialogTitle);
    }

    public String getPassword() {
        return new String(this.m_password.getPassword());
    }

    public String getUsername() {
        return this.m_username.getText();
    }

    public String getItem() {
        if (this.m_chosenItem != null) {
            return this.m_chosenItem;
        }
        if (this.m_items != null && this.m_itemsComboBox != null && this.m_itemsComboBox.getSelectedIndex() < this.m_items.size()) {
            return this.m_items.get(this.m_itemsComboBox.getSelectedIndex());
        }
        return null;
    }

    private VWPLCredentials(Frame parent, JPanel panel, String title, int optionType, Dimension size, List<String> items, String chosenItem, String username, String pw, String itemName) {
        super(parent, panel, title, optionType, null, size);
        panel.setLayout(new BorderLayout(10, 10));
        this.m_mainPanel = this.getMainPanel(items, chosenItem, username, pw, itemName);
        panel.add((Component)this.m_mainPanel, "Center");
    }

    @Override
    protected void performValidation() throws Exception {
        this.m_mainPanel.validateTextFields();
        String password1 = new String(this.m_password.getPassword());
        String password2 = new String(this.m_confirmPassword.getPassword());
        if (!password1.equals(password2)) {
            throw new VWException("filenet.vw.apps.taskman.wfservices.VWChangeDB2PasswordDialog.PasswordsDoNotMatch", "The passwords do not match.");
        }
    }

    @Override
    protected void processButtonEvent(int button) throws Exception {
        if (button == 4) {
            this.m_isCanceled = true;
        }
    }

    protected boolean getIsCanceled() {
        return this.m_isCanceled;
    }

    private VWTaskTabPanel getMainPanel(List<String> items, String chosenItem, String username, String pw, String itemName) {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        if (items != null) {
            this.m_items = items;
            this.m_itemsComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(items.toArray()));
            this.m_itemsComboBox.setName(itemName);
            this.m_itemsComboBox.setSelectedIndex(0);
            this.m_itemsComboBox.setRenderer(new VWLabelListCellRenderer());
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_itemsComboBox.applyComponentOrientation(compOrientation);
            panel.add((Component)new JLabel(this.m_itemsComboBox.getName() + ":"), c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 1;
            panel.add((Component)this.m_itemsComboBox, c);
        } else if (chosenItem != null) {
            this.m_chosenItem = chosenItem;
            this.m_itemTextField = new JTextField();
            this.m_itemTextField.setName(itemName);
            this.m_itemTextField.setText(chosenItem);
            this.m_itemTextField.setEnabled(false);
            panel.add((Component)new JLabel(this.m_itemTextField.getName() + ":"), c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 1;
            panel.add((JTextComponent)this.m_itemTextField, (Object)c, true);
        }
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_username = new JTextField();
        this.m_username.setText(username);
        this.m_username.setName(VWResource.UserName);
        panel.add((Component)new JLabel(this.m_username.getName() + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_username, (Object)c, true);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_password = new JPasswordField();
        this.m_password.setText(pw);
        this.m_password.setName(VWResource.Password);
        panel.add((Component)new JLabel(this.m_password.getName() + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_password, (Object)c, true);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_confirmPassword = new JPasswordField();
        this.m_confirmPassword.setText(pw);
        this.m_confirmPassword.setName(VWResource.ConfirmPassword);
        panel.add((Component)new JLabel(this.m_confirmPassword.getName() + ":"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_confirmPassword, (Object)c, true);
        return panel;
    }
}

